<?php
require __DIR__ . '/../config.php';

header('Content-Type: application/json');

function json_response(array $data): void
{
    echo json_encode($data);
    exit;
}

$key = $_GET['key'] ?? '';
$hwid = $_GET['hwid'] ?? '';
$activity = $_GET['activity'] ?? '';

if ($key === '') {
    json_response(['ok' => false, 'error' => 'INVALID_KEY']);
}

// Find license
$stmt = $mysqli->prepare('SELECT * FROM licenses WHERE license_key = ? LIMIT 1');
$stmt->bind_param('s', $key);
$stmt->execute();
$result = $stmt->get_result();
$license = $result->fetch_assoc();
$stmt->close();

if (!$license) {
    json_response(['ok' => false, 'error' => 'INVALID_KEY']);
}

// If blocked or expired, respond but still record last_seen for debugging if you want;
// here we'll just reject.
if ($license['status'] === 'blocked') {
    json_response(['ok' => false, 'error' => 'BLOCKED']);
}

if (!empty($license['expiry_date']) && strtotime($license['expiry_date']) < strtotime(date('Y-m-d'))) {
    // mark expired
    if ($license['status'] !== 'expired') {
        $upd = $mysqli->prepare("UPDATE licenses SET status = 'expired' WHERE id = ?");
        $id = (int)$license['id'];
        $upd->bind_param('i', $id);
        $upd->execute();
        $upd->close();
    }
    json_response(['ok' => false, 'error' => 'EXPIRED']);
}

// HWID check same as verify
if (!empty($license['hwid'])) {
    if ($hwid === '' || $hwid !== $license['hwid']) {
        json_response(['ok' => false, 'error' => 'HWID_MISMATCH']);
    }
} else {
    // If no HWID stored yet and one is provided, you may bind it here (optional)
    if ($hwid !== '') {
        $bind = $mysqli->prepare('UPDATE licenses SET hwid = ? WHERE id = ?');
        $id = (int)$license['id'];
        $bind->bind_param('si', $hwid, $id);
        $bind->execute();
        $bind->close();
    }
}

$now = date('Y-m-d H:i:s');
$ip = $_SERVER['REMOTE_ADDR'] ?? '';

$upd = $mysqli->prepare('UPDATE licenses SET last_seen = ?, current_activity = ?, ip_address = ? WHERE id = ?');
$id = (int)$license['id'];
$upd->bind_param('sssi', $now, $activity, $ip, $id);
$upd->execute();
$upd->close();

json_response(['ok' => true]);


