<?php
// Basic configuration for database and session

session_start();

$db_host = '127.0.0.1';
$db_user = 'root';
$db_pass = '';
$db_name = 'shah_license_db';

$mysqli = new mysqli($db_host, $db_user, $db_pass, $db_name);

if ($mysqli->connect_errno) {
    die('Failed to connect to MySQL: ' . $mysqli->connect_error);
}

// Helper: require login for admin pages
function require_admin_login(): void
{
    if (empty($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
        header('Location: login.php');
        exit;
    }
}

// Helper: escape output (safe for null / non-string values)
function h($value): string
{
    if ($value === null) {
        $value = '';
    }
    return htmlspecialchars((string)$value, ENT_QUOTES, 'UTF-8');
}

